﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public partial class PatientImagingDB : DBUtils
    {
        public IEnumerable<PatientImageView> GetImagesForPatient(
            int PATIENT_ID,
            int START_ROW,
            int MAX_ROWS,
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID)
        {
            IEnumerable<PatientImageView> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetImagesForPatient(PATIENT_ID, START_ROW, MAX_ROWS)
                        .ToList();
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int GetImagesForPatientCount(
            int PATIENT_ID,
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetImagesForPatientCount(PATIENT_ID, ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }
    }
}
